/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.spelunkery.blocks.fungi;

import com.ordana.spelunkery.Spelunkery;
import com.ordana.spelunkery.reg.ModBlockProperties;
import com.ordana.spelunkery.reg.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MillyBubcapMushroomBlock
extends BushBlock
implements BonemealableBlock {
    public static final int MAX_CAPS = 8;
    public static final IntegerProperty CAPS = ModBlockProperties.CAPS;
    protected static final VoxelShape ONE_AABB = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    protected static final VoxelShape TWO_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
    protected static final VoxelShape THREE_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0);
    protected static final VoxelShape FOUR_AABB = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)7.0, (double)14.0);

    public MillyBubcapMushroomBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)CAPS, (Comparable)Integer.valueOf(1)));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
        if (blockState.m_60713_((Block)this)) {
            return (BlockState)blockState.m_61124_((Property)CAPS, (Comparable)Integer.valueOf(Math.min(8, (Integer)blockState.m_61143_((Property)CAPS) + 1)));
        }
        return super.m_5573_(context);
    }

    protected boolean m_6266_(BlockState state, BlockGetter level, BlockPos pos) {
        return !state.m_60812_(level, pos).m_83263_(Direction.UP).m_83281_() || state.m_60783_(level, pos, Direction.UP);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        return this.m_6266_(level.m_8055_(blockPos), (BlockGetter)level, blockPos);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)level, currentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        return !useContext.m_7078_() && useContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)CAPS) < 8 || super.m_6864_(state, useContext);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 vec3 = state.m_60824_(level, pos);
        return switch ((Integer)state.m_61143_((Property)CAPS)) {
            default -> ONE_AABB.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            case 2 -> TWO_AABB.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            case 3 -> THREE_AABB.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
            case 4, 5, 6, 7, 8 -> FOUR_AABB.m_83216_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{CAPS});
    }

    public boolean growMushroom(ServerLevel level, BlockPos pos, BlockState state, RandomSource random) {
        if (((ConfiguredFeature)((Holder)((Registry)level.m_5962_().m_6632_(Registry.f_122881_).get()).m_203636_(ResourceKey.m_135785_((ResourceKey)Registry.f_122881_, (ResourceLocation)Spelunkery.res("huge_milly_bubcap_bonemeal"))).get()).m_203334_()).m_224953_((WorldGenLevel)level, level.m_7726_().m_8481_(), random, pos)) {
            return true;
        }
        level.m_7731_(pos, state, 3);
        return false;
    }

    public boolean m_7370_(BlockGetter level, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource random, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if ((Integer)state.m_61143_((Property)CAPS) == 8) {
            this.growMushroom(level, pos, state, random);
        }
        int j = 1;
        int l = 0;
        int m = pos.m_123341_() - 2;
        int n = 0;
        for (int o = 0; o < 5; ++o) {
            for (int p = 0; p < j; ++p) {
                int q = 2 + pos.m_123342_() - 1;
                for (int r = q - 2; r < q; ++r) {
                    BlockState blockState;
                    BlockPos blockPos = new BlockPos(m + o, r, pos.m_123343_() - n + p);
                    if (blockPos == pos || random.m_188503_(6) != 0 || !level.m_8055_(blockPos).m_60795_() || !(blockState = level.m_8055_(blockPos.m_7495_())).m_204336_(BlockTags.f_13057_)) continue;
                    level.m_7731_(blockPos, (BlockState)ModBlocks.MILLY_BUBCAP.get().m_49966_().m_61124_((Property)CAPS, (Comparable)Integer.valueOf(random.m_188503_(8) + 1)), 3);
                }
            }
            if (l < 2) {
                j += 2;
                ++n;
            } else {
                j -= 2;
                --n;
            }
            ++l;
        }
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)CAPS, (Comparable)Integer.valueOf(8)), 2);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

